<?php

/**
 * This is the model class for table "Bank".
 *
 * The followings are the available columns in table 'Bank':
 * @property double $id
 * @property string $nazwa
 * @property double $idBudynku
 * @property double $oplataZalozenie
 * @property double $oplataMiesieczna
 * @property double $oprocentowanie
 * @property string $opis
 * @property double $oplataPrzelew
 */
class Bank extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Bank the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Bank';
	}

	public function buindingExists()
	{
		$building = Budynek::model()->findByPk($this->idBudynku);
		if(empty($building))
		{
			$this->addError('idBudynku', 'Ten budynek nie istnieje');
		}
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idBudynku', 'required'),
			array('idBudynku, oplataZalozenie, oplataMiesieczna, oprocentowanie, oplataPrzelew', 'numerical'),
			array('nazwa', 'length', 'max'=>64),
			array('opis', 'length', 'max'=>4000),
			array('idBudynku', 'buindingExists'),

			array('id, nazwa, idBudynku, oplataZalozenie, oplataMiesieczna, oprocentowanie, opis, oplataPrzelew', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'idBudynku0'=>array(self::BELONGS_TO, 'Budynek', 'idBudynku'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Bank', 'ID'),
			'nazwa'=>Yii::t('Bank', 'Nazwa'),
			'idBudynku'=>Yii::t('Bank', 'Budynek'),
			'oplataZalozenie'=>Yii::t('Bank', 'Opłata założenie [zł]'),
			'oplataMiesieczna'=>Yii::t('Bank', 'Opłata miesięczna [zł]'),
			'oplataPrzelew'=>Yii::t('Bank', 'Opłata przelew [zł]'),
			'oprocentowanie'=>Yii::t('Bank', 'Oprocentowanie [%]'),
			'opis'=>Yii::t('Bank', 'Opis'),
			'oplataPrzelew'=>Yii::t('Bank', 'Opłata za przelew'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare(Yii::app()->db->quoteColumnName("id"), $this->id);
		$criteria->compare('LOWER("t"."nazwa")', strtolower($this->nazwa), true);
		$criteria->compare('LOWER("idBudynku0"."nazwa")', strtolower($this->idBudynku), true);
		$criteria->compare(Yii::app()->db->quoteColumnName("oplataZalozenie"), $this->oplataZalozenie);
		$criteria->compare(Yii::app()->db->quoteColumnName("oplataMiesieczna"), $this->oplataMiesieczna);
		$criteria->compare(Yii::app()->db->quoteColumnName("oplataPrzelew"), $this->oplataPrzelew);
		$criteria->compare(Yii::app()->db->quoteColumnName("oprocentowanie"), $this->oprocentowanie);
		$criteria->compare('LOWER("t"."opis")', strtolower($this->opis), true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
